using System;
using System.Drawing;
using System.Windows.Forms;
using System.Runtime.InteropServices;
using ControlesAt;
using Globales;
using System.IO;

namespace Inercial{
	public struct Enlaces{
		public PanelesSub.IEnlace PanelEdTexto1;
	}
	internal struct ConfiguracionPrograma{
		public string OpenPath;
	}

	public class PanelInercial : PanelesSub.PanelSubordinado{
		private System.Windows.Forms.MenuItem	CUnidades,
															unirad, unigon, unisex;
		private System.Windows.Forms.MenuItem CSalida;
		private System.Windows.Forms.OpenFileDialog Open1;
		internal System.Windows.Forms.TabControl	TabControl1;
		internal System.Windows.Forms.TabPage		TabPrincipal,	TabErrores;

		internal System.Windows.Forms.GroupBox GroupBox1;
		private ControlesAt.LabelTxtBotAbrir	TxtBotgps,	TxtBotimu,
														TxtBotpau;
		private ControlesAt.Labeltf		Tfgps, Tfimu;
		private System.Windows.Forms.GroupBox GroupBox2;
		private ControlesAt.LTFloat	TxtOffsetX,	TxtOffsetY,
											TxtOffsetZ;
		//private System.Windows.Forms.GroupBox GroupBox3;

		private ControlesAt.LTFloat TxtsigmaGPS;
		private System.Windows.Forms.Label Label24;
		private System.Windows.Forms.GroupBox GroupBox4;
			private ControlesAt.LTFloat TxtsigmaAcel;
			private System.Windows.Forms.Label Label25;
			private System.Windows.Forms.CheckBox ChkAceldespl;
			private System.Windows.Forms.GroupBox GBoxAceldespl;
				private System.Windows.Forms.RadioButton	AceldesplConocido0,	//Conocido perfecto
																		AceldesplConocido1,	//Conocido con incertidumbre
																		AceldesplConocido2;	//desconocido
				private ControlesAt.LTFloat	TxtAceldesplX,	TxtAceldesplY,
													TxtAceldesplZ;
				private ControlesAt.LabelRight	Label22;
				private ControlesAt.LTFloat	TxtsigmaAceldesplXY,		TxtsigmaAceldesplZ;
			private System.Windows.Forms.CheckBox ChkAcelescala;
			private System.Windows.Forms.GroupBox GBoxAcelescala;
				private System.Windows.Forms.RadioButton	AcelescalaConocido0,
																		AcelescalaConocido1,
																		AcelescalaConocido2;
				private ControlesAt.LTFloat TxtAcelescala;
				private ControlesAt.LTFloat TxtsigmaAcelescala;
		private System.Windows.Forms.GroupBox GroupBox5;
			private ControlesAt.LTFloat TxtsigmaGiros;
			private System.Windows.Forms.Label Label26;
			private System.Windows.Forms.CheckBox ChkGirosdespl;
			private System.Windows.Forms.GroupBox GBoxGirosdespl;
				private System.Windows.Forms.RadioButton	GirosdesplConocido0,
																		GirosdesplConocido1,
																		GirosdesplConocido2;
				private ControlesAt.LTFloat	TxtGirosdesplW,		TxtGirosdesplPhi,
													TxtGirosdesplK;
				private ControlesAt.LabelRight Label23;
				private ControlesAt.LTFloat	TxtsigmaGirosdesplWF,	TxtsigmaGirosdesplK;

		internal ControlesAt.BotAceptar Calcular;

	#region Variables
		internal new byte idioma{
			get{return base.idioma;}
		}
		private bool idioma_read;
		internal Enlaces enlaces;
		internal ConfiguracionPrograma ConfigPrograma;
	#endregion

	#region Inicializacin
		public PanelInercial(Form _GranParent, Globales.Duenno _owner, string[] argv, PanelesSub.IEnlace[] _enlaces) : base(_GranParent,_owner)
		{
			if(_enlaces==null || _enlaces.Length<1) enlaces.PanelEdTexto1=null;
			else enlaces.PanelEdTexto1=_enlaces[0];
			InitializeComponent();
			inizializeb(argv);
		}
		unsafe public PanelInercial(Form _GranParent, ushort** argv,byte _idioma) : base(_GranParent,_idioma)
		{
			enlaces.PanelEdTexto1=null;
			InitializeComponent();
			ushort** ptr=argv;
			uint n=0;
			while(*ptr!=(void*)0){ptr++; n++;}
			string[] Argv=new string[n];
			ptr=argv;
			uint i=0;
			while(*ptr!=(void*)0){
                        Argv[i]=Marshal.PtrToStringUni(new IntPtr(*ptr));
				i++; ptr++;
			}
			//Marshal.FreeHGlobal(new IntPtr((void*)argv));
			inizializeb(Argv);
		}
		protected override void inizializeb(string[] argv){
			AppData=Environment.GetFolderPath(Environment.SpecialFolder.ApplicationData)+"\\Aerotri\\";
			if(!System.IO.Directory.Exists(AppData)) System.IO.Directory.CreateDirectory(AppData);
			icono= new System.Drawing.Icon(System.Reflection.Assembly.GetExecutingAssembly().GetManifestResourceStream("Inercial.Iconos.IconInercial.ico"));
			MessageBoxAT.Owner=GranParent;
			MessageBoxAT.Caption="Inercial";

			if(enlaces.PanelEdTexto1==null) enlaces.PanelEdTexto1=PanelesSub.Statics.DummyEnlace;

			FormAcercade1=new FormAcercade(typeof(PanelInercial),idioma);
			FormAcercade1.Icon= icono;
			FormAcercade1.LabelIcono.Image= icono.ToBitmap();

			FormAcercade1.Owner=GranParent;

			AceldesplConocido_CheckedChanged(this, EventArgs.Empty);
			AcelescalaConocido_CheckedChanged(this, EventArgs.Empty);
			GirosdesplConocido_CheckedChanged(this, EventArgs.Empty);

			idioma_read=false;
			lee_ficheroConfiguracion("Inercial.config");
			if(!idioma_read && Myowner.duenno.m==0){
				idioma_read=PanelesSub.varias.read_reg_language("Aerotri","InstallLanguage",ref base.idioma);
			}

			update_idioma();
			colores();
		}
		protected override void lee_ficheroConfiguracion(string nombre){
			base.lee_ficheroConfiguracion(nombre);
			ConfigPrograma.OpenPath=__OpenPath;
		}
		protected override void procesa_linea_config(string tipo, string[] palabras){
			if(!idioma_read) if(tipo=="Idioma") idioma_read=true;
			base.procesa_linea_config (tipo, palabras);
		}
	#endregion

	#region InitializeComponent
		private void InitializeComponent()
		{
			//MenuOpciones= new ContextMenu();	//uncomment if needed.
			CUnidades= new MenuItem();
			CSalida= new MenuItem();
			unigon= new MenuItem();		unirad= new MenuItem();		unisex= new MenuItem();

			Open1= new OpenFileDialog();
			TabControl1= new TabControl();
			TabPrincipal= new TabPage();
			TabErrores= new TabPage();

			GroupBox1= new GroupBox();
			TxtBotgps= new LabelTxtBotAbrir();		Tfgps= new Labeltf(2);
			TxtBotimu= new LabelTxtBotAbrir();	Tfimu= new Labeltf(2);
			TxtBotpau= new LabelTxtBotAbrir();
			GroupBox2= new GroupBox();
			TxtOffsetX= new LTFloat();
			TxtOffsetY= new LTFloat();
			TxtOffsetZ= new LTFloat();
			//GroupBox3= new GroupBox();

			TxtsigmaGPS= new LTFloat();		Label24= new Label();
			GroupBox4= new GroupBox();
				TxtsigmaAcel= new LTFloat();		Label25= new Label();
				ChkAceldespl=new CheckBox();
				GBoxAceldespl= new GroupBox();
				AceldesplConocido0= new RadioButton();
				AceldesplConocido1= new RadioButton();
				AceldesplConocido2= new RadioButton();
				TxtAceldesplX= new LTFloat();
				TxtAceldesplY= new LTFloat();
				TxtAceldesplZ= new LTFloat();
				Label22= new LabelRight();
				TxtsigmaAceldesplXY= new LTFloat();
				TxtsigmaAceldesplZ= new LTFloat();
				ChkAcelescala= new CheckBox();
				GBoxAcelescala= new GroupBox();
				AcelescalaConocido0= new RadioButton();
				AcelescalaConocido1= new RadioButton();
				AcelescalaConocido2= new RadioButton();
				TxtAcelescala= new LTFloat();
				TxtsigmaAcelescala= new LTFloat();
			GroupBox5= new GroupBox();
				TxtsigmaGiros= new LTFloat();	Label26= new Label();
				ChkGirosdespl= new CheckBox();
				GBoxGirosdespl= new GroupBox();
				GirosdesplConocido0= new RadioButton();
				GirosdesplConocido1= new RadioButton();
				GirosdesplConocido2= new RadioButton();
				TxtGirosdesplW= new LTFloat();
				TxtGirosdesplPhi= new LTFloat();
				TxtGirosdesplK= new LTFloat();
				Label23= new LabelRight();
				TxtsigmaGirosdesplWF= new LTFloat();
				TxtsigmaGirosdesplK= new LTFloat();

			Calcular= new BotAceptar();

			//PanelMenu1.Controls.Remove(PanelMenu1.gLabels("Archivo"));		//uncoment if needed
			//PanelMenu1.AddLabel("Opciones",MenuOpciones);					//Items are docked at the left, hence this procedure for inserting in the middle
			//PanelMenu1.Controls.Add(PanelMenu1.gLabels("Archivo"));			//The already built in items are: "Archivo", "Configuracion" and "Ayuda".
			//
			// MenuConfiguracion
			//
			MenuConfiguracion.MenuItems.AddRange(new MenuItem[] {	CUnidades,
																						CSalida});
			//
			// CUnidades
			CUnidades.Index= 0;
			CUnidades.MenuItems.AddRange(new MenuItem[] {	unirad, unigon, unisex});
			//
			// unirad, gon, sex
			unirad.Index= 0;
			unigon.Index= 1;
			unisex.Index= 2;
			unigon.Checked= true;
			unirad.Click+= new EventHandler(unirad_Click);
			unigon.Click+= new EventHandler(unigon_Click);
			unisex.Click+= new EventHandler(unisex_Click);
			//
			// CSalida
			CSalida.Index= 1;
			CSalida.Visible= false;
			CSalida.Click+= new EventHandler(CSalida_Click);
			//
			//TabControl
			//
			TabControl1.Controls.Add(this.TabPrincipal);
			TabControl1.Controls.Add(this.TabErrores);
			TabControl1.Location= new Point(4, 20);
			TabControl1.SelectedIndex= 0;
			TabControl1.Size= new Size(612, 328);
			TabControl1.TabIndex= 1;
			//
			// TabPrincipal
			//
			TabPrincipal.Controls.Add(this.GroupBox1);
			TabPrincipal.Controls.Add(this.GroupBox2);
			TabPrincipal.TabIndex= 0;
			//
			// GroupBox1
			//
			GroupBox1.Controls.Add(TxtBotgps);
			GroupBox1.Controls.Add(TxtBotimu);
			GroupBox1.Controls.Add(TxtBotpau);
			GroupBox1.Controls.Add(Tfgps);
			GroupBox1.Controls.Add(Tfimu);
			GroupBox1.Location= new Point(0, 0);
			GroupBox1.Size= new Size(600, 116);
			GroupBox1.TabIndex= 0;
			//
			// TxtBotgps, imu, pau
			TxtBotgps.TextLocation= new Point(116, 16);		TxtBotgps.TabIndex= 0;
			TxtBotimu.TextLocation= new Point(408, 16);		TxtBotimu.TabIndex= 2;
			TxtBotpau.TextLocation= new Point(116, 80);		TxtBotpau.TabIndex= 4;
			TxtBotgps.Click+= new EventHandler(Botabrirgps_Click);
			TxtBotimu.Click+= new EventHandler(Botabririmu_Click);
			TxtBotpau.Click+= new EventHandler(Botabrirpau_Click);
			//
			// Tfgps, imu
			Tfgps.Location= new Point(23, 44);		Tfgps.TabIndex= 1;
			Tfimu.Location= new Point(319, 48);	Tfimu.TabIndex= 3;
			//
			// GroupBox2
			//
			GroupBox2.Controls.Add(TxtOffsetX);
			GroupBox2.Controls.Add(TxtOffsetY);
			GroupBox2.Controls.Add(TxtOffsetZ);
			GroupBox2.Location= new Point(0, 124);
			GroupBox2.Size= new Size(600, 46);
			GroupBox2.TabIndex= 1;
			//
			// TxtOffsetX, Y, Z
			TxtOffsetX.TextLocation= new Point(60,20);		TxtOffsetX.TabIndex= 0;
			TxtOffsetY.TextLocation= new Point(260,20);		TxtOffsetY.TabIndex= 1;
			TxtOffsetZ.TextLocation= new Point(460,20);		TxtOffsetZ.TabIndex= 2;
			TxtOffsetX.L.Text="X";
			TxtOffsetY.L.Text="Y";
			TxtOffsetZ.L.Text="Z";
			//
			// TabErrores
			//
			TabErrores.Controls.Add(TxtsigmaGPS);
			TabErrores.Controls.Add(Label24);
			TabErrores.Controls.Add(this.GroupBox4);
			TabErrores.Controls.Add(this.GroupBox5);
			TabErrores.TabIndex= 1;
			//
			// TxtsigmaGPS, Label24
			TxtsigmaGPS.TextLocation= new Point(164,18);		TxtsigmaGPS.TabIndex= 0;
			Label24.Top= TxtsigmaGPS.Top+3;
			Label24.Left= TxtsigmaGPS.Right+2;
			Label24.Width=12;
			Label24.Text= "m";
			Label24.TabIndex= 1;
			//
			// GroupBox4
			//
			GroupBox4.Controls.Add(TxtsigmaAcel);
			GroupBox4.Controls.Add(Label25);
			GroupBox4.Controls.Add(ChkAceldespl);
			GroupBox4.Controls.Add(GBoxAceldespl);
			GroupBox4.Controls.Add(ChkAcelescala);
			GroupBox4.Controls.Add(GBoxAcelescala);
			GroupBox4.Location= new Point(264,0);
			GroupBox4.Size= new Size(336,252);
			GroupBox4.TabIndex= 3;
			//
			// TxtsigmaAcel, Label25
			TxtsigmaAcel.TextLocation= new Point(176,18);		TxtsigmaAcel.TabIndex= 0;
			Label25.Top= TxtsigmaAcel.Top+3;
			Label25.Left= TxtsigmaAcel.Right+2;
			Label25.Width=32;
			Label25.Text= "m/s2";
			Label25.TabIndex= 1;
			//
			// ChkAceldespl
			ChkAceldespl.FlatStyle= FlatStyle.System;
			ChkAceldespl.Location= new Point(16,44);
			ChkAceldespl.Size= new Size(128,16);
			ChkAceldespl.Checked= true;
			ChkAceldespl.TabIndex= 2;
			ChkAceldespl.CheckedChanged+= new EventHandler(ChkAceldespl_CheckedChanged);
			//
			// GBoxAceldespl
			//
			GBoxAceldespl.Controls.AddRange(new Control[]{
					AceldesplConocido0,	AceldesplConocido1,	AceldesplConocido2,
					TxtAceldesplX,
					TxtAceldesplY,
					TxtAceldesplZ,
					Label22,
					TxtsigmaAceldesplXY,		TxtsigmaAceldesplZ
			});
			GBoxAceldespl.Location= new Point(4,46);
			GBoxAceldespl.Width= GroupBox4.Width-8;
			GBoxAceldespl.Height= 116;
			GBoxAceldespl.TabIndex= 4;
			//
			// AceldesplConocido
			AceldesplConocido2.FlatStyle= AceldesplConocido1.FlatStyle= AceldesplConocido0.FlatStyle= FlatStyle.System;
			AceldesplConocido0.Location= new Point(6,20);			AceldesplConocido0.Size= new Size(110,16);		AceldesplConocido0.TabIndex= 0;
			AceldesplConocido1.Location= new Point(118,20);		AceldesplConocido1.Size= new Size(124,16);		AceldesplConocido1.TabIndex= 1;
			AceldesplConocido2.Location= new Point(244,20);		AceldesplConocido2.Size= new Size(82,16);			AceldesplConocido2.TabIndex= 2;
			AceldesplConocido2.Checked= true;
			AceldesplConocido0.CheckedChanged+= new EventHandler(AceldesplConocido_CheckedChanged);
			AceldesplConocido1.CheckedChanged+= new EventHandler(AceldesplConocido_CheckedChanged);
			AceldesplConocido2.CheckedChanged+= new EventHandler(AceldesplConocido_CheckedChanged);
			//
			// TxtAceldesplX, Y, Z
			TxtAceldesplX.TextLocation=new Point(24,52);		TxtAceldesplX.TabIndex= 3;
			TxtAceldesplY.TextLocation=new Point(128,52);		TxtAceldesplY.TabIndex= 4;
			TxtAceldesplZ.TextLocation=new Point(232,52);		TxtAceldesplZ.TabIndex= 5;
			TxtAceldesplX.L.Text="X";
			TxtAceldesplY.L.Text="Y";
			TxtAceldesplZ.L.Text="Z";
			//
			// Label22
			Label22.RefLocation= new Point(84,86);	Label22.TabIndex= 9;
			//
			// TxtsigmaAceldesplX,Y y Z
			TxtsigmaAceldesplXY.TextLocation= new Point(128,84);		TxtsigmaAceldesplXY.TabIndex= 10;
			TxtsigmaAceldesplZ.TextLocation= new Point(232,84);		TxtsigmaAceldesplZ.TabIndex= 11;
			TxtsigmaAceldesplXY.L.Text="X, Y";
			TxtsigmaAceldesplZ.L.Text="Z";
			//
			// ChkAcelescala
			ChkAcelescala.FlatStyle= FlatStyle.System;
			ChkAcelescala.Location= new Point(16,164);
			ChkAcelescala.Size= new Size(164,16);
			ChkAcelescala.Checked= false;
			ChkAcelescala.CheckedChanged+= new EventHandler(ChkAcelescala_CheckedChanged);
			//
			// GBoxAcelescala
			//
			GBoxAcelescala.Controls.AddRange(new Control[]{
					AcelescalaConocido0,
					AcelescalaConocido1,
					AcelescalaConocido2,
					TxtAcelescala,
					TxtsigmaAcelescala
			});
			GBoxAcelescala.Location= new Point(4,166);
			GBoxAcelescala.Width= GBoxAceldespl.Width;
			GBoxAcelescala.Height= 82;
			GBoxAcelescala.Enabled= false;
			//
			// AcelescalaConocido
			AcelescalaConocido2.FlatStyle= AcelescalaConocido1.FlatStyle= AcelescalaConocido0.FlatStyle= FlatStyle.System;
			AcelescalaConocido0.Location= new Point(6,20);			AcelescalaConocido0.Size= new Size(110,16);		AcelescalaConocido0.TabIndex= 0;
			AcelescalaConocido1.Location= new Point(118,20);		AcelescalaConocido1.Size= new Size(124,16);		AcelescalaConocido1.TabIndex= 1;
			AcelescalaConocido2.Location= new Point(244,20);		AcelescalaConocido2.Size= new Size(82,16);		AcelescalaConocido2.TabIndex= 2;
			AcelescalaConocido2.Checked= true;
			AcelescalaConocido0.CheckedChanged+= new EventHandler(AcelescalaConocido_CheckedChanged);
			AcelescalaConocido1.CheckedChanged+= new EventHandler(AcelescalaConocido_CheckedChanged);
			AcelescalaConocido2.CheckedChanged+= new EventHandler(AcelescalaConocido_CheckedChanged);
			//
			// TxtAcelescala: valor, sigma
			TxtAcelescala.TextLocation=new Point(68,52);				TxtAcelescala.TabIndex= 3;
			TxtsigmaAcelescala.TextLocation=new Point(220,52);	TxtsigmaAcelescala.TabIndex= 4;
			//
			// GroupBox5
			//
			GroupBox5.Controls.Add(TxtsigmaGiros);
			GroupBox5.Controls.Add(Label26);
			GroupBox5.Controls.Add(ChkGirosdespl);
			GroupBox5.Controls.Add(GBoxGirosdespl);
			GroupBox5.Location= new Point(0,52);
			GroupBox5.Size= new Size(260,200);
			GroupBox5.TabIndex= 4;
			//
			// TxtsigmaGiros, Label26
			TxtsigmaGiros.TextLocation= new Point(156,18);		TxtsigmaGiros.TabIndex= 0;
			Label26.Top= TxtsigmaGiros.Top+3;
			Label26.Left= TxtsigmaGiros.Right+2;
			Label26.Width=24;
			Label26.Text= "rad.";
			Label26.TabIndex= 1;
			//
			// ChkGirosdespl
			ChkGirosdespl.FlatStyle= FlatStyle.System;
			ChkGirosdespl.Location= new Point(16,44);
			ChkGirosdespl.Size= new Size(128,16);
			ChkGirosdespl.Checked= true;
			ChkGirosdespl.TabIndex= 3;
			ChkGirosdespl.CheckedChanged+= new EventHandler(ChkGirosdespl_CheckedChanged);
			//
			// GBoxGirosdespl
			//
			GBoxGirosdespl.Controls.AddRange(new Control[]{
					GirosdesplConocido0,		GirosdesplConocido1,		GirosdesplConocido2,
					TxtGirosdesplW,
					TxtGirosdesplPhi,
					TxtGirosdesplK,
					Label23,
					TxtsigmaGirosdesplWF,	TxtsigmaGirosdesplK
			});
			GBoxGirosdespl.Location= new Point(4,46);
			GBoxGirosdespl.Width= GroupBox5.Width-8;
			GBoxGirosdespl.Height= 150;
			GBoxGirosdespl.TabIndex= 4;
			//
			// GirosdesplConocido
			GirosdesplConocido2.FlatStyle= GirosdesplConocido1.FlatStyle= GirosdesplConocido0.FlatStyle= FlatStyle.System;
			GirosdesplConocido0.Location= new Point(6,20);			GirosdesplConocido0.Size= new Size(110,16);			GirosdesplConocido0.TabIndex= 0;
			GirosdesplConocido1.Location= new Point(6,44);			GirosdesplConocido1.Size= new Size(124,16);			GirosdesplConocido1.TabIndex= 1;
			GirosdesplConocido2.Location= new Point(6,68);			GirosdesplConocido2.Size= new Size(100,16);			GirosdesplConocido2.TabIndex= 2;
			GirosdesplConocido2.Checked= true;
			GirosdesplConocido0.CheckedChanged+= new EventHandler(GirosdesplConocido_CheckedChanged);
			GirosdesplConocido1.CheckedChanged+= new EventHandler(GirosdesplConocido_CheckedChanged);
			GirosdesplConocido2.CheckedChanged+= new EventHandler(GirosdesplConocido_CheckedChanged);
			//
			// TxtGirosdesplW, Phi, K
			TxtGirosdesplW.TextLocation= new Point(158,18);		TxtGirosdesplW.TabIndex= 3;
			TxtGirosdesplPhi.TextLocation= new Point(158,42);		TxtGirosdesplPhi.TabIndex= 4;
			TxtGirosdesplK.TextLocation= new Point(158,66);		TxtGirosdesplK.TabIndex= 5;
			TxtGirosdesplW.L.Font= new Font("Symbol", 8.25F);		TxtGirosdesplW.L.Text="W";
			TxtGirosdesplPhi.L.Font= TxtGirosdesplW.L.Font;			TxtGirosdesplPhi.L.Text="F";
			TxtGirosdesplK.L.Font= TxtGirosdesplW.L.Font;			TxtGirosdesplK.L.Text="K";
			//
			// Label23
			Label23.RefLocation= new Point(100, 100);		Label23.TabIndex= 6;
			//
			// TxtsigmaGirosdesplWF: W, F y K
			TxtsigmaGirosdesplWF.TextLocation= new Point(158,98);		TxtsigmaGirosdesplWF.TabIndex= 7;
			TxtsigmaGirosdesplK.TextLocation= new Point(158,122);		TxtsigmaGirosdesplK.TabIndex= 8;
			TxtsigmaGirosdesplWF.L.Font= TxtGirosdesplW.L.Font;		TxtsigmaGirosdesplWF.L.Text="W, F";
			TxtsigmaGirosdesplK.L.Font= TxtGirosdesplW.L.Font;			TxtsigmaGirosdesplK.L.Text="K";

			//
			// Calcular
			//
			Calcular.Location= new Point(288, 376);
			Calcular.TabIndex= 2;
			Calcular.Click+= new EventHandler(Calcular_Click);
			//
			// PanelInercial
			//
			this.Controls.Add(this.TabControl1);
			this.Controls.Add(Calcular);
			this.Size= new Size(618, 424);
		}
	#endregion

		protected override void cierra_todo(System.ComponentModel.CancelEventArgs e){
			guarda_ficheroConfiguracion("Inercial.config");
		}
		protected override void escribe_fConfiguracion(System.IO.StreamWriter fconfig){
			base.escribe_fConfiguracion_comienzo(fconfig);
			fconfig.WriteLine("OpenPath \"" + ConfigPrograma.OpenPath +"\"");
		}

	#region Abrir
		private void Botabrirgps_Click(object sender, EventArgs e)
		{
			ahora_no_se_puede_cerrar=1;
			Methods.BotAbrir_Click(TxtBotgps.T,Tfgps, Open1, ref ConfigPrograma.OpenPath, new SetFilterDelegate(SetFiltergps));
			ahora_no_se_puede_cerrar=0;
		}
		private void Botabririmu_Click(object sender, EventArgs e){
			ahora_no_se_puede_cerrar=1;
			Methods.BotAbrir_Click(TxtBotimu.T,Tfimu, Open1, ref ConfigPrograma.OpenPath, new SetFilterDelegate(SetFilterimu));
			ahora_no_se_puede_cerrar=0;
		}
		private void Botabrirpau_Click(object sender, EventArgs e){
			ahora_no_se_puede_cerrar=1;
			Methods.BotAbrir_Click(TxtBotpau.T,null, Open1, ref ConfigPrograma.OpenPath, new SetFilterDelegate(SetFilterpau));
			ahora_no_se_puede_cerrar=0;
		}

		void SetFiltergps(FileDialog Open1){
			switch(idioma){
				case 1 : Open1.Filter="Not marked files (*.pre.gps)|*.pre.gps|Marked files (*.pre.gpm)|*.pre.gpm|Text files (*.txt)|*.txt|All files (*.*)|*.*"; break;
				case 2 : Open1.Filter="File senza segnare (*.pre.gps)|*.pre.gps|File segnati (*.pre.gpm)|*.pre.gpm|File di Testo (*.txt)|*.txt|Tutti i file (*.*)|*.*"; break;
				default:Open1.Filter="Ficheros sin marcar (*.pre.gps)|*.pre.gps|Ficheros marcados (*.pre.gpm)|*.pre.gpm|Ficheros de Texto (*.txt)|*.txt|Todos los ficheros (*.*)|*.*"; break;
			}
		}
		void SetFilterimu(FileDialog Open1){
			switch(idioma){
				case 1 : Open1.Filter="Not marked files (*.pre.imu)|*.pre.imu|Marked files (*.pre.imm)|*.pre.imm|Text files (*.txt)|*.txt|All files (*.*)|*.*"; break;
				case 2 : Open1.Filter="File senza segnare (*.pre.imu)|*.pre.imu|File segnati (*.pre.imm)|*.pre.imm|File di Testo (*.txt)|*.txt|Tutti i file (*.*)|*.*"; break;
				default:Open1.Filter="Ficheros sin marcar (*.pre.imu)|*.pre.imu|Ficheros marcados (*.pre.imm)|*.pre.imm|Ficheros de Texto (*.txt)|*.txt|Todos los ficheros (*.*)|*.*"; break;
			}
		}
		void SetFilterpau(FileDialog Open1){
			switch(idioma){
				case 1 : Open1.Filter="Pause files (*.pau)|*.pau|Text files (*.txt)|*.txt|All files (*.*)|*.*"; break;
				case 2 : Open1.Filter="File di pausa (*.pau)|*.pau|File di Testo (*.txt)|*.txt|Tutti i file (*.*)|*.*"; break;
				default:Open1.Filter="Ficheros de pausa (*.pau)|*.pau|Ficheros de Texto (*.txt)|*.txt|Todos los ficheros (*.*)|*.*"; break;
			}
		}
	#endregion

	#region ModeloErrorCheckedChanged
		private void ChkAceldespl_CheckedChanged(object sender, EventArgs e){
			 GBoxAceldespl.Enabled= ChkAceldespl.Checked;
		}
		private void AceldesplConocido_CheckedChanged(object sender, EventArgs e){
			if(AceldesplConocido2.Checked){
				TxtAceldesplX.Enabled=false;
				TxtAceldesplY.Enabled=false;
				TxtAceldesplZ.Enabled=false;
			}else{
				TxtAceldesplX.Enabled=true;
				TxtAceldesplY.Enabled=true;
				TxtAceldesplZ.Enabled=true;
			}
			if(AceldesplConocido1.Checked){
				TxtsigmaAceldesplXY.Enabled=true;
				TxtsigmaAceldesplZ.Enabled=true;
			}else{
				TxtsigmaAceldesplXY.Enabled=false;
				TxtsigmaAceldesplZ.Enabled=false;
			}
		}

		private void ChkAcelescala_CheckedChanged(object sender, EventArgs e){
			GBoxAcelescala.Enabled= ChkAcelescala.Checked;
		}
		private void AcelescalaConocido_CheckedChanged(object sender, EventArgs e){
			TxtAcelescala.Enabled= !AcelescalaConocido2.Checked;
			TxtsigmaAcelescala.Enabled= AcelescalaConocido1.Checked;
		}

		private void ChkGirosdespl_CheckedChanged(object sender, EventArgs e){
			GBoxGirosdespl.Enabled= ChkGirosdespl.Checked;
		}
		private void GirosdesplConocido_CheckedChanged(object sender, EventArgs e){
			if(GirosdesplConocido2.Checked){
				TxtGirosdesplW.Enabled=false;
				TxtGirosdesplPhi.Enabled=false;
				TxtGirosdesplK.Enabled=false;
			}else{
				TxtGirosdesplW.Enabled=true;
				TxtGirosdesplPhi.Enabled=true;
				TxtGirosdesplK.Enabled=true;
			}
			if(GirosdesplConocido1.Checked){
				TxtsigmaGirosdesplWF.Enabled=true;
				TxtsigmaGirosdesplK.Enabled=true;
			}else{
				TxtsigmaGirosdesplWF.Enabled=false;
				TxtsigmaGirosdesplK.Enabled=false;
			}
		}
	#endregion

	#region Configuracion
	#region Unidades de los giros
		void unirad_Click(Object sender, System.EventArgs e){
			unirad.Checked=true;
			unigon.Checked=false;
			unisex.Checked=false;
		}
		void unigon_Click(Object sender, System.EventArgs e){
			unirad.Checked=false;
			unigon.Checked=true;
			unisex.Checked=false;
		}
		void unisex_Click(Object sender, System.EventArgs e){
			unirad.Checked=false;
			unigon.Checked=false;
			unisex.Checked=true;
		}
	#endregion
		void CSalida_Click(Object sender, System.EventArgs e){
			//FormSalida1.ShowDialog();
		}
	#endregion

	#region Calcular
		void contenta_al_imbecil(out InterComInercial.ModeloErrores errores){
			errores.sigmaGPS=0;
			errores.acel.bdespl=errores.acel.bescala=0;
			errores.acel.escala=errores.acel.desplX=errores.acel.desplY=errores.acel.desplZ=0;
			errores.acel.sigma=errores.acel.sigmadesplXY=errores.acel.sigmadesplZ=errores.acel.sigmaescala=0;
			errores.giros.bdespl=0;
			errores.giros.desplW=errores.giros.desplPhi=errores.giros.desplK=0;
			errores.giros.sigma=errores.giros.sigmadesplWF=errores.giros.sigmadesplK=0;
		}
		unsafe void Calcular_Click(Object sender, System.EventArgs e){
			int returned;
			sbyte uni=0;	//Imbcil
			sbyte extragps;
			byte pam;
			InterComInercial.ModeloErrores errores;
				contenta_al_imbecil(out errores);
			System.IntPtr P_ext=Marshal.StringToHGlobalAnsi(new string((char)0,5));
			string mensaje=new string((char)0, 255);
			System.IntPtr P_mensaje=Marshal.StringToHGlobalAnsi(mensaje);
			System.IntPtr P_nombrebaseCEx= new IntPtr(0);
			void* log_file=(void*)0;
			System.IntPtr P_gps= IntPtr.Zero;
			System.IntPtr P_imu= IntPtr.Zero;
			System.IntPtr P_pau= IntPtr.Zero;
			uint log_level;
			int naux;
			string saux;
			float offsetX, offsetY, offsetZ;

			if(TxtBotgps.Text==""){
				MessageBoxAT.Show(textos(31));
				goto @return;
			}
			if(TxtBotimu.Text==""){
				MessageBoxAT.Show(textos(32));
				goto @return;
			}
			extragps=Basicas._gcVarios.pospunto(TxtBotgps.Text);
			Basicas._gcVarios.normaliza_n_ext(ref extragps, 4);
			if(extragps!=4 && (naux=(TxtBotgps.Text.Length + extragps))>=8 &&
			    TxtBotgps.Text.Substring(naux-8,4)==".pre"){
				if(Tfgps.tipof!=0 && System.IO.Path.GetExtension(TxtBotgps.Text)==".gps"){
					MessageBoxAT.Show(textos(33));
					goto @return;
				}
			}else{
				if(System.IO.Path.GetExtension(TxtBotgps.Text)==".gpm"){
					MessageBoxAT.Show(textos(54));
					goto @return;
				}
				extragps+=4;
			}
			P_gps=				Marshal.StringToHGlobalAnsi(TxtBotgps.Text + new string((char)0, extragps));
			P_nombrebaseCEx=Marshal.StringToHGlobalAnsi(TxtBotgps.Text+ new string((char)0, extragps));
			Basicas._nogcVarios.extension(P_nombrebaseCEx,extragps, 108, 111, 103);

			saux=Marshal.PtrToStringAnsi(P_nombrebaseCEx);
			saux=saux.Substring(0,saux.Length-4);
			System.IntPtr P_largo=Marshal.StringToHGlobalAnsi(saux+"_ajuste.log");
			log_file=Basicas._nogcVarios.crea_fichero(P_largo);
			Marshal.FreeHGlobal(P_largo);

			saux="Clculo comenzado en "+DateTime.Now.ToString()+"\n";
			P_largo=Marshal.StringToHGlobalAnsi(saux);
			Basicas._nogcVarios.escribe_fichero(log_file,P_largo);
			Marshal.FreeHGlobal(P_largo);
			log_level=1;

			if(TxtBotimu.Text.Length>=8 && TxtBotimu.Text.Substring(TxtBotimu.Text.Length-8,8) == ".pre.imu"){
				MessageBoxAT.Show(textos(34));
				goto @return;
			}
			P_imu=Marshal.StringToHGlobalAnsi(TxtBotimu.Text);

			try{if(TxtOffsetX.Text=="") throw new Exception();
				offsetX=Basicas._gcVarios.atofl(TxtOffsetX.Text.ToCharArray());
			}catch(Exception){
				MessageBoxAT.Show(textos(35));
				goto @return;
			}
			try{if(TxtOffsetY.Text=="") throw new Exception();
				offsetY=Basicas._gcVarios.atofl(TxtOffsetX.Text.ToCharArray());
			}catch(Exception){
				MessageBoxAT.Show(textos(36));
				goto @return;
			}
			try{if(TxtOffsetZ.Text=="") throw new Exception();
				offsetZ=Basicas._gcVarios.atofl(TxtOffsetX.Text.ToCharArray());
			}catch(Exception){
				MessageBoxAT.Show(textos(37));
				goto @return;
			}

			try{if(TxtsigmaGPS.Text=="") throw new Exception();
				errores.sigmaGPS=Basicas._gcVarios.atofl(TxtsigmaGPS.Text.ToCharArray());
			}catch(Exception){
				MessageBoxAT.Show(textos(38));
				goto @return;
			}
			try{if(TxtsigmaAcel.Text=="") throw new Exception();
				errores.acel.sigma=Basicas._gcVarios.atofl(TxtsigmaAcel.Text.ToCharArray());
			}catch(Exception){
				MessageBoxAT.Show(textos(39));
				goto @return;
			}
			try{if(TxtsigmaGiros.Text=="") throw new Exception();
				errores.giros.sigma=Basicas._gcVarios.atofl(TxtsigmaGiros.Text.ToCharArray());
			}catch(Exception){
				MessageBoxAT.Show(textos(40));
				goto @return;
			}

			if(!ChkAceldespl.Checked){
				errores.acel.bdespl=0;
				errores.acel.desplX=0;
				errores.acel.desplY=0;
				errores.acel.desplZ=0;
			}else if(AceldesplConocido2.Checked){
				errores.acel.bdespl=1;
				errores.acel.sigmadesplXY=0;
				errores.acel.sigmadesplZ=0;
			}else{
				try{if(TxtAceldesplX.Text=="") throw new Exception();
					errores.acel.desplX=Basicas._gcVarios.atofl(TxtAceldesplX.Text.ToCharArray());
				}catch(Exception){
					MessageBoxAT.Show(textos(41));
					goto @return;
				}
				try{if(TxtAceldesplY.Text=="") throw new Exception();
					errores.acel.desplY=Basicas._gcVarios.atofl(TxtAceldesplY.Text.ToCharArray());
				}catch(Exception){
					MessageBoxAT.Show(textos(42));
					goto @return;
				}
				try{if(TxtAceldesplZ.Text=="") throw new Exception();
					errores.acel.desplZ=Basicas._gcVarios.atofl(TxtAceldesplZ.Text.ToCharArray());
				}catch(Exception){
					MessageBoxAT.Show(textos(43));
					goto @return;
				}
				if(AceldesplConocido0.Checked) errores.acel.bdespl=0;
				else{
					errores.acel.bdespl=1;
					try{if(TxtsigmaAceldesplXY.Text=="") throw new Exception();
						errores.acel.sigmadesplXY=Basicas._gcVarios.atofl(TxtsigmaAceldesplXY.Text.ToCharArray());
					}catch(Exception){
						MessageBoxAT.Show(textos(44));
						goto @return;
					}
					try{if(TxtsigmaAceldesplZ.Text=="") throw new Exception();
						errores.acel.sigmadesplZ=Basicas._gcVarios.atofl(TxtsigmaAceldesplZ.Text.ToCharArray());
					}catch(Exception){
						MessageBoxAT.Show(textos(45));
						goto @return;
					}
				}
			}

			if(!ChkAcelescala.Checked){
				errores.acel.bescala=0;
				errores.acel.escala=0;
			}else if(AcelescalaConocido2.Checked){
				errores.acel.bescala=1;
				errores.acel.sigmaescala=0;
			}else{
				try{if(TxtAcelescala.Text=="") throw new Exception();
					errores.acel.escala=(double)Basicas._gcVarios.atofl(TxtAcelescala.Text.ToCharArray());
				}catch(Exception){
					MessageBoxAT.Show(textos(46));
					goto @return;
				}
				if(AcelescalaConocido0.Checked) errores.acel.bescala=0;
				else{
					errores.acel.bescala=1;
					try{if(TxtsigmaAcelescala.Text=="") throw new Exception();
						errores.acel.sigmaescala=Basicas._gcVarios.atofl(TxtsigmaAcelescala.Text.ToCharArray());
					}catch(Exception){
						MessageBoxAT.Show(textos(47));
						goto @return;
					}
				}
			}

			if(!ChkGirosdespl.Checked){
				errores.giros.bdespl=0;
				errores.giros.desplW=0;
				errores.giros.desplPhi=0;
				errores.giros.desplK=0;
			}else if(GirosdesplConocido2.Checked){
				errores.giros.bdespl=1;
				errores.giros.sigmadesplWF=0;
				errores.giros.sigmadesplK=0;
			}else{
				try{if(TxtGirosdesplW.Text=="") throw new Exception();
					    errores.giros.desplW=Basicas._gcVarios.atofl(TxtGirosdesplW.Text.ToCharArray());
				}catch(Exception){
					MessageBoxAT.Show(textos(48));
					goto @return;
				}
				try{if(TxtGirosdesplPhi.Text=="") throw new Exception();
					errores.giros.desplPhi=Basicas._gcVarios.atofl(TxtGirosdesplPhi.Text.ToCharArray());
				}catch(Exception){
					MessageBoxAT.Show(textos(49));
					goto @return;
				}
				try{if(TxtGirosdesplK.Text=="") throw new Exception();
					errores.giros.desplK=Basicas._gcVarios.atofl(TxtGirosdesplK.Text.ToCharArray());
				}catch(Exception){
					MessageBoxAT.Show(textos(50));
					goto @return;
				}
				if(GirosdesplConocido0.Checked) errores.giros.bdespl=0;
				else{
					errores.giros.bdespl=1;
					try{if(TxtsigmaGirosdesplWF.Text=="") throw new Exception();
						errores.giros.sigmadesplWF=Basicas._gcVarios.atofl(TxtsigmaGirosdesplWF.Text.ToCharArray());
					}catch(Exception){
						MessageBoxAT.Show(textos(51));
						goto @return;
					}
					try{if(TxtsigmaGirosdesplK.Text=="") throw new Exception();
						errores.giros.sigmadesplK=Basicas._gcVarios.atofl(TxtsigmaGirosdesplK.Text.ToCharArray());
					}catch(Exception){
						MessageBoxAT.Show(textos(52));
						goto @return;
					}
				}
			}

			if(TxtBotpau.Text=="") pam=255;
			else{
				P_pau=Marshal.StringToHGlobalAnsi(TxtBotpau.Text);
				pam=0;
			}
			if(unirad.Checked) uni=0;
			else if(unigon.Checked) uni=1;
			else uni=2;

			ahora_no_se_puede_cerrar=1;
			try{
				set_message(textos(22));
				returned=InterComInercial.maininercial(this.Handle,log_file,log_level, P_gps,Tfgps.tipof,extragps, P_imu,Tfimu.tipof, P_pau,pam, (byte)1,offsetX,offsetY,offsetZ,errores,uni, P_mensaje,idioma);
			}catch(System.DllNotFoundException){
				returned=-2;
				mensaje=textos(53);
			}finally{
				set_message(mensaje_pordefecto);
			}

		@return:
			Marshal.FreeHGlobal(P_mensaje);
			Marshal.FreeHGlobal(P_ext);
			if(P_nombrebaseCEx!=System.IntPtr.Zero) Marshal.FreeHGlobal(P_nombrebaseCEx);
			if(P_gps!=System.IntPtr.Zero) Marshal.FreeHGlobal(P_gps);
			if(P_imu!=System.IntPtr.Zero) Marshal.FreeHGlobal(P_imu);
			if(P_pau!=System.IntPtr.Zero) Marshal.FreeHGlobal(P_pau);
			ahora_no_se_puede_cerrar=0;
			return;
		}
	#endregion

		protected override void colores(){
			base.colores();
			TabPrincipal.BackColor= Color.FromArgb(Globales.Colores.color0);
			TabErrores.BackColor= Color.FromArgb(Globales.Colores.color0);
			TxtBotpau.T.BackColor= Color.FromArgb(Globales.Colores.color2);
			Calcular.BackColor= Color.FromArgb(Globales.Colores.color6);
		}

	#region etiquetas_idiomas
		protected override void etiquetas_esp(){
			if(GranParent!=null)
				 GranParent.Text= "Inercial";

			base.etiquetas_esp();
			//PanelMenu1.gLabels("Opciones").Text= "Opciones";
			CUnidades.Text= "Unidades de los giros";
			unirad.Text= "Radianes";
			unigon.Text= "g. centesimales";
			unisex.Text= "g. sexagesimales";
			CSalida.Text= "Informacin de salida...";
			AAcercade.Text= "Acerca de Inercial";
			ManualPath= "Manuales_html\\esp\\Inercial.htm";
			FormAcercade1.titulo="Acerca de Inercial";
			FormAcercade1.cabecera="Ajuste de IMU con datos GPS";
			FormAcercade1.fecha="26 de marzo de 2010";

			TabPrincipal.Text= "Principal";
			TabErrores.Text= "Modelo de errores";
			TxtBotgps.L.Text= "Fichero de datos GPS";
			TxtBotimu.L.Text= "Fichero de datos IMU ";
			TxtBotpau.L.Text= "Fichero de pausas";
			Tfgps.set_textos(new string[]{"Sin marcar","Marcado"});
			Tfimu.set_textos(new string[]{"Sin marcar","Marcado"});
			Tfgps.actualiza();   Tfimu.actualiza();

			GroupBox2.Text= "Offset del receptor GPS respecto al IMU";
			TxtsigmaGPS.L.Text= "Precisin de las medidas GPS";

			GroupBox4.Text= "Acelermetros";
			TxtsigmaAcel.L.Text= "Precisin de las medidas";
			ChkAceldespl.Text= "Error constante (m/s2)";
			AceldesplConocido0.Text= "Conocido exacto";
			AceldesplConocido1.Text= "Conocido impreciso";		AceldesplConocido1.Width=120;
			AceldesplConocido2.Text= "Desconocido";		AceldesplConocido2.Left=240;	AceldesplConocido2.Width=86;
			Label22.Text= "Precisin:";
			ChkAcelescala.Text= "Error de escala (tanto por 1)";
			AcelescalaConocido0.Text= "Conocido exacto";
			AcelescalaConocido1.Text= "Conocido impreciso";	AcelescalaConocido1.Width=120;
			AcelescalaConocido2.Text= "Desconocido";		AcelescalaConocido2.Left=240;	AcelescalaConocido2.Width=86;
			TxtAcelescala.L.Text="Valor";
			TxtsigmaAcelescala.L.Text= "Precisin";

			GroupBox5.Text= "Girscopos";
			TxtsigmaGiros.L.Text= "Precisin de las medidas";
			ChkGirosdespl.Text= "Error constante (rad.)";
			GirosdesplConocido0.Text= "Conocido exacto";
			GirosdesplConocido1.Text= "Conocido impreciso";
			GirosdesplConocido2.Text= "Desconocido";
			Label23.Text= "Precisin:";

			Calcular.Text= "Calcular";
		}

		protected override void etiquetas_eng(){
			if(GranParent!=null)
				 GranParent.Text= "Inertial";

			base.etiquetas_eng();
			//PanelMenu1.gLabels("Opciones").Text= "Options";
			CUnidades.Text= "Angle units";
			unirad.Text= "Radians";
			unigon.Text= "Centesimal d.";
			unisex.Text= "Sexagesimal d.";
			CSalida.Text= "Output information...";
			AAcercade.Text= "About Inertial";
			ManualPath= "Manuales_html\\eng\\Inertial.htm";
			FormAcercade1.titulo="About Inertial";
			FormAcercade1.cabecera="IMU adjustment with GPS data";
			FormAcercade1.fecha="March 26, 2010";

			TabPrincipal.Text= "Main";
			TabErrores.Text= "Error model";
			TxtBotgps.L.Text= "GPS data file";
			TxtBotimu.L.Text= "IMU data file ";
			TxtBotpau.L.Text= "File of stops";
			Tfgps.set_textos(new string[]{"Not marked","Marked"});
			Tfimu.set_textos(new string[]{"Not marked","Marked"});
			Tfgps.actualiza();   Tfimu.actualiza();

			GroupBox2.Text= "Offset of GPS receiver with respect to IMU";
			TxtsigmaGPS.L.Text= "Precision of GPS measurements";

			GroupBox4.Text= "Accelerometers";
			TxtsigmaAcel.L.Text= "Precision of measurements";
			ChkAceldespl.Text= "Constant error (m/s2)";
			AceldesplConocido0.Text= "Known, exact";
			AceldesplConocido1.Text= "Known, inexact";		AceldesplConocido1.Width=124;
			AceldesplConocido2.Text= "Unknown";		AceldesplConocido2.Left=244;	AceldesplConocido2.Width=82;
			Label22.Text= "Precision:";
			ChkAcelescala.Text= "Scale factor error (parts per 1)";
			AcelescalaConocido0.Text= "Known, exact";
			AcelescalaConocido1.Text= "Known, inexact";		AcelescalaConocido1.Width=124;
			AcelescalaConocido2.Text= "Unknown";	AcelescalaConocido2.Left=244;	AcelescalaConocido2.Width=82;
			TxtAcelescala.L.Text="Value";
			TxtsigmaAcelescala.L.Text= "Precision";

			GroupBox5.Text= "Girscopos";
			TxtsigmaGiros.L.Text= "Precision of measurements";
			ChkGirosdespl.Text= "Constant error (rad.)";
			GirosdesplConocido0.Text= "Known, exact";
			GirosdesplConocido1.Text= "Known, inexact";
			GirosdesplConocido2.Text= "Unknown";
			Label23.Text= "Precision:";

			Calcular.Text= "Calculate";
		}

		protected override void etiquetas_it(){
			if(GranParent!=null)
				 GranParent.Text= "Inerziale";

			base.etiquetas_it();
			//PanelMenu1.gLabels("Opciones").Text= "Opzioni";
			CUnidades.Text= "Unit dei giri";
			unirad.Text= "Radianti";
			unigon.Text= "g. centesimali";
			unisex.Text= "g. sessagesimali";
			CSalida.Text= "Informazione d'uscita...";
			AAcercade.Text= "Su Inerziale";
			ManualPath= "Manuales_html\\it\\Inerziale.htm";
			FormAcercade1.titulo="Su Inerziale";
			FormAcercade1.cabecera="Compensazione di IMU con dati GPS";
			FormAcercade1.fecha="26 marzo 2010";

			TabPrincipal.Text= "Principale";
			TabErrores.Text= "Modello d'errori";
			TxtBotgps.L.Text= "File di dati GPS";
			TxtBotimu.L.Text= "File di dati IMU ";
			TxtBotpau.L.Text= "File di pause";
			Tfgps.set_textos(new string[]{"No segnato","Segnato"});
			Tfimu.set_textos(new string[]{"No segnato","Segnato"});
			Tfgps.actualiza();   Tfimu.actualiza();

			GroupBox2.Text= "Offset dello recettore GPS in relazione all'IMU";
			TxtsigmaGPS.L.Text= "Precisione delle misure GPS";

			GroupBox4.Text= "Acelerometri";
			TxtsigmaAcel.L.Text= "Precisione delle misure";
			ChkAceldespl.Text= "Errore costante (m/s2)";
			AceldesplConocido0.Text= "Conosciuto esatto";
			AceldesplConocido1.Text= "Conosciuto impreciso";		AceldesplConocido1.Width=124;
			AceldesplConocido2.Text= "Sconosciuto";		AceldesplConocido2.Left=244;	AceldesplConocido2.Width=82;
			Label22.Text= "Precisione:";
			ChkAcelescala.Text= "Errore di scala (tanto per 1)";
			AcelescalaConocido0.Text= "Conosciuto esatto";
			AcelescalaConocido1.Text= "Conosciuto impreciso";		AcelescalaConocido1.Width=124;
			AcelescalaConocido2.Text= "Sconosciuto";		AcelescalaConocido2.Left=244;	AcelescalaConocido2.Width=82;
			TxtAcelescala.L.Text="Valore";
			TxtsigmaAcelescala.L.Text= "Precisione";

			GroupBox5.Text= "Giroscopi";
			TxtsigmaGiros.L.Text= "Precisione delle misure";
			ChkGirosdespl.Text= "Errore costante (rad.)";
			GirosdesplConocido0.Text= "Conosciuto esatto";
			GirosdesplConocido1.Text= "Conosciuto impreciso";
			GirosdesplConocido2.Text= "Sconosciuto";
			Label23.Text= "Precisione:";

			Calcular.Text= "Calcola";
		}
		#endregion

	#region textos
		internal string textos(short i){
			string txt="";
			switch(idioma){
			 case 1:
				switch(i){
					case 20 : txt= "Calculation finished"; break;
					case 21 : txt= "Computing approximate values"; break;
					case 22 : txt= "Waiting for the end of the computation"; break;
					case 31: txt= "A GPS data file has to be specified"; break;
					case 32: txt= "An IMU data file has to be specified"; break;
					case 33: txt= "The extension pre.gps can only be used with not marked files"; break;
					case 34: txt= "The extension pre.imu can only be used with not marked files"; break;
					case 35: txt= "Wrong value for the GPS X offset"; break;
					case 36: txt= "Wrong value for the GPS Y offset"; break;
					case 37: txt= "Wrong value for the GPS Z offset"; break;
					case 38: txt= "Wrong value for the GPS measurements precision"; break;
					case 39: txt= "Wrong value for the accelerometers measurements precision"; break;
					case 40: txt= "Wrong value for the giros measurements precision"; break;
					case 41: txt= "Wrong value for the acelometer X constant error"; break;
					case 42: txt= "Wrong value for the acelometer Y constant error"; break;
					case 43: txt= "Wrong value for the acelometer Z constant error"; break;
					case 44: txt= "Wrong value for the acelometers X,Y constant error precision"; break;
					case 45: txt= "Wrong value for the acelometer Z constant error precision"; break;
					case 46: txt= "Wrong value for the acelometer scale error"; break;
					case 47: txt= "Wrong value for the acelometers scale error precision"; break;
					case 48: txt= "Wrong value for the Giro W constant error"; break;
					case 49: txt= "Wrong value for the Giro Phi constant error"; break;
					case 50: txt= "Wrong value for the Giro K constant error"; break;
					case 51: txt= "Wrong value for the Giros W,Phi constant error precision"; break;
					case 52: txt= "Wrong value for the Giro K constant error precision"; break;
					case 53: txt= "The file ajinercial.dll couldn't be opened"; break;
					case 54: txt= "The extension gpm is not allowed"; break;
					case 55: txt= "The current configuration will become the configuration every time the program starts."; break;

					case 60: txt= "Reading the Inertial work file"; break;
					case 61: txt= "Writting the Inertial work file"; break;
					case 62: txt= "Writing the configuration file"; break;
				}
				break;
			 case 2:
				switch(i){
					case 20 : txt= "Calcolo finito"; break;
					case 21 : txt= "Calcolando valori approssimati"; break;
					case 22 : txt= "Aspettando che finisca il calcolo"; break;
					case 31: txt= "Deve indicare un file di dati GPS"; break;
					case 32: txt= "Deve indicare un file di dati IMU"; break;
					case 33: txt= "L'estensione pre.gps solo pu utilizzarsi con file senza segnare"; break;
					case 34: txt= "L'estensione pre.imu solo pu utilizzarsi con file senza segnare"; break;
					case 35: txt= "Valore dell'offset GPS, X, erroneo"; break;
					case 36: txt= "Valore dell'offset GPS, Y, erroneo"; break;
					case 37: txt= "Valore dell'offset GPS, Z, erroneo"; break;
					case 38: txt= "Valore di precisione delle misure GPS erroneo"; break;
					case 39: txt= "Valore di precisione delle misure delle acelerometri erroneo"; break;
					case 40: txt= "Valore di precisione delle misure dei giroscopi erroneo"; break;
					case 41: txt= "Valore dell'errore costante dell'acelerometro X erroneo"; break;
					case 42: txt= "Valore dell'errore costante dell'acelerometro Y erroneo"; break;
					case 43: txt= "Valore dell'errore costante dell'acelerometro Z erroneo"; break;
					case 44: txt= "Valore di precisione dell'errore costante degli acelerometri X,Y erroneo"; break;
					case 45: txt= "Valore di precisione dell'errore costante dell'acelerometro Z erroneo"; break;
					case 46: txt= "Valore dell'errore di scala degli acelerometri erroneo"; break;
					case 47: txt= "Valore di precisione dell'errore di scala degli acelerometri erroneo"; break;
					case 48: txt= "Valore dell'errore costante del giroscopo W erroneo"; break;
					case 49: txt= "Valore dell'errore costante del giroscopo Phi erroneo"; break;
					case 50: txt= "Valore dell'errore costante del giroscopo K erroneo"; break;
					case 51: txt= "Valore di precisione dell'errore costante dei giroscopi W,Phi erroneo"; break;
					case 52: txt= "Valore di precisione dell'errore costante del giroscopo K erroneo"; break;
					case 53: txt= "Non  possibile aprire il file ajinercial.dll"; break;
					case 54: txt= "L'estensione gpm no si pu utilizzare"; break;
					case 55: txt= "La configurazione attuale sar la che mostre il programa sempre nella sua apertura"; break;

					case 60: txt= "Leggendo il file di lavoro"; break;
					case 61: txt= "Scrivendo il file di lavoro"; break;
					case 62: txt= "Scrivendo il file di configurazione"; break;
				}
				break;
			 default:
				switch(i){
					case 20 : txt= "Clculo terminado"; break;
					case 21 : txt= "Calculando valores aproximados"; break;
					case 22 : txt= "Esperando a que termine el clculo"; break;
					case 31: txt= "Debe indicar un fichero de datos GPS"; break;
					case 32: txt= "Debe indicar un fichero de datos IMU"; break;
					case 33: txt= "La extensin pre.gps est reservada a ficheros sin marcar"; break;
					case 34: txt= "La extensin pre.imu est reservada a ficheros sin marcar"; break;
					case 35: txt= "Valor del offset GPS, X, errneo"; break;
					case 36: txt= "Valor del offset GPS, Y, errneo"; break;
					case 37: txt= "Valor del offset GPS, Z, errneo"; break;
					case 38: txt= "Valor de precisin de las medidas GPS errneo"; break;
					case 39: txt= "Valor de precisin de las medidas de lo acelermetros errneo"; break;
					case 40: txt= "Valor de precisin de las medidas de los girscopos errneo"; break;
					case 41: txt= "Valor de error constante del acelermetro X errneo"; break;
					case 42: txt= "Valor de error constante del acelermetro Y errneo"; break;
					case 43: txt= "Valor de error constante del acelermetro Z errneo"; break;
					case 44: txt= "Valor de precisin del error constante de los acelermetros X,Y errneo"; break;
					case 45: txt= "Valor de precisin del error constante del acelermetro Z errneo"; break;
					case 46: txt= "Valor de error de escala de los acelermetros errneo"; break;
					case 47: txt= "Valor de precisin del error de escala de los acelermetros errneo"; break;
					case 48: txt= "Valor de error constante del girscopo W errneo"; break;
					case 49: txt= "Valor de error constante del girscopo Phi errneo"; break;
					case 50: txt= "Valor de error constante del girscopo K errneo"; break;
					case 51: txt= "Valor de precisin del error constante de los girscopos W,Phi errneo"; break;
					case 52: txt= "Valor de precisin del error constante del girscopo K errneo"; break;
					case 53: txt= "No se ha podido abrir el fichero ajinercial.dll"; break;
					case 54: txt= "La extensin gpm no puede emplearse"; break;
					case 55: txt= "De esta manera la configuracin actual ser la que tenga el programa al abrirse."; break;

					case 60: txt= "Leyendo el fichero de trabajo"; break;
					case 61: txt= "Escribiendo el fichero de trabajo"; break;
					case 62: txt= "Escribiendo el fichero de configuracin"; break;
				}
				break;
			}
			return txt;
		}
	#endregion

	}
}